<?php
/* Copyright (C) 2016 Garcia MICHEL <garcia@soamichel.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

dol_include_once('/autoupgrade/class/autoupgrade.class.php');

class ActionsAutoUpgrade {
	protected $db;

	function ActionsAutoUpgrade($db){
		$this->db = $db;
	}

	function afterLogin($parameters, &$object, &$action, $hookmanager){
		global $langs, $conf;

		$langs->load('autoupgrade@autoupgrade');

		if($object->admin){
			$obj = new AutoUpgrade($this->db, $langs);
			try{
				$versions = $obj->checkNewVersions(intval($conf->global->AUTOUPGRADE_SHOWUNSTABLE));
				if($versions){
					setEventMessage($langs->trans("UpgradeAvailable"));
				}
			}catch(Exception $e){
				setEventMessage($e->getMessage(), "errors");
			}
		}
	}

  function printTopRightMenu($parameters, &$object, &$action, $hookmanager){
    global $langs, $conf, $user;

		$langs->load('autoupgrade@autoupgrade');

		if($user->admin){
			$obj = new AutoUpgrade($this->db, $langs);
			try{
				$versions = $obj->checkNewVersions(intval($conf->global->AUTOUPGRADE_SHOWUNSTABLE));
				if($versions){
          $text= '<a href="'.dol_buildpath('/autoupgrade/admin/index.php', 1).'">'.img_object('', 'autoupgrade@autoupgrade').'</a>';
          $this->resprints = @Form::textwithtooltip('', $langs->trans("UpgradeAvailable"), 2, 1, $text, 'login_block_elem', 2);
          return 0;
				}
			}catch(Exception $e){}
		}
  }
}
