<?php
/* Copyright (C) 2016 Garcia MICHEL <garcia@soamichel.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

class ZipArchive2 extends ZipArchive{
  public function addDir($dir, $localdir=null){
    if(!is_dir($dir))
      throw new Exception($dir.' not found.');

    if($localdir)
      $this->addEmptyDir($localdir);

    $dh = opendir($dir);
    if(!$dir)
      throw new Exception($dir.' can not open');

    while($file = readdir($dh)){
      if($file == '.' or $file == '..') continue;

      $path = $dir . '/' . $file;
      $localpath = $localdir ? ($localdir . '/' . $file) : $file;
      if(is_dir($path)){
        $this->addDir($path, $localpath);
      }else{
        $this->addFile($path, $localpath);
      }
    }
    closedir($dh);
  }
}
?>
